/*
 * ContagionModels.h
 *
 *  Created on: Nov 19, 2013
 *      Author: nino
 */

#ifndef CONTAGIONMODELS_H_
#define CONTAGIONMODELS_H_




#include <StandardLibs.h>
#include <NetworkStructure.h>
#include <ContagionParameters.h>


typedef enum{
    NAIVE_SIR_UNWEIGHTED_NET,
    NAIVE_SIR_WEIGHTED_NET,
    //MC_PRUNING_SIR_UNWEIGHTED_NET,
    LAZY_RECOVERY_SIR_TEMPORAL_NET,
    LAZY_RECOVERY_SIR_TEMPORAL_NET_FROM_TO,
    FAST_SIR_UNWEIGHTED_NET,
    CLASSIC_ISS_UNWEIGHTED_NET,
} SIMULATION_TYPE;

void run_contagion_model(infected_structure * p_infected_parameters, SIMULATION_TYPE sim_type, igraph_vector_t * infected_nodes_history , contagion_param_struct * epidemicParameters, unsigned seed);

void run_contagion_model(infected_structure * p_infected_parameters, SIMULATION_TYPE sim_type, igraph_vector_t * infected_nodes_history , contagion_param_struct * epidemicParameters_exp, unsigned seed, int sim_num);

void igraph_epidemic_classic_temporal(infected_structure * p_infected_parameters, double p, double q, igraph_vector_t * infected_nodes, int T_value);

void igraph_SIR_temporal_contact_network(infected_structure * p_infected_parameters, double p, double q, igraph_vector_t * infected_nodes_history, int T_value, unsigned seed);

void igraph_SIR_temporal_contact_network(infected_structure * p_infected_parameters, double p, double q, igraph_vector_t * infected_nodes_history, int T_start, int T_end, unsigned seed);

void igraph_SIR_temporal_contact_network(infected_structure * p_infected_parameters, double p, double q, igraph_vector_t * infected_nodes_history, int T_start, int T_end, unsigned seed, int sim_num);

void igraph_epidemic_weighted_temporal(infected_structure * p_infected_parameters, double p, double q, igraph_vector_t * infected_nodes, int T_value);

double my_random();

void randomize_temporal_contacts(infected_structure * p_infected_parameters, int T_value, unsigned seed);

void igraph_epidemic_classic_temporal_prunning_identitiy(infected_structure * p_infected_parameters, double p, double q, igraph_vector_t * infected_nodes, int T_value, igraph_vector_t * observed_realization, int * is_prunned);

void igraph_epidemic_classic_MC_pruning(infected_structure * p_infected_parameters, double p, double q, igraph_vector_t * infected_nodes, int T_value, igraph_vector_t * observed_realization, int * is_prunned, int error_threshold_nodes);

void clear_vector_idx(igraph_dqueue_t * queue_infected_nodes_all, igraph_vector_t * realization);

int getRandomDayFromPeriod(int start, int end);

void randomize_temporal_contacts_uniformly(infected_structure * p_infected_parameters, int T_value, unsigned seed);

void sort_temporal_contact_by_time(infected_structure * p_infected_parameters, vector<pair<int,int>> * contactRnd_time);

#endif /* CONTAGIONMODELS_H_ */
